/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Scanner;

public class Update {
    static String localGlobalVersion = String.valueOf(Main.curDir) + "/Version.txt";
    static String globalVersion = "";
    static boolean main = false;

    public static void fetchUpdates() {
        try {
            Files.deleteIfExists(Paths.get(localGlobalVersion, new String[0]));
        }
        catch (IOException e1) {
            System.out.println("Failed to delete old data, ignore this...");
        }
        System.out.println("Attempting to fetch updates...");
        try {
            BufferedInputStream in = new BufferedInputStream(Main.onlineVersion.openStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buf))) {
                out.write(buf, 0, n);
            }
            out.close();
            ((InputStream)in).close();
            byte[] response = out.toByteArray();
            FileOutputStream fos = new FileOutputStream(new File(localGlobalVersion));
            fos.write(response);
            fos.close();
        }
        catch (IOException e) {
            System.out.println("File could not be downloaded, server potentially offline.");
            AppWindow.updates.setText("Server Offline");
            AppWindow.updates.setForeground(Color.red);
        }
        if (!new File(localGlobalVersion).exists()) {
            AppWindow.updates.setText("Server Offline");
            AppWindow.updates.setForeground(Color.red);
        } else {
            try {
                Update.checkUpdates();
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found, download failed");
            }
        }
    }

    public static void checkUpdates() throws FileNotFoundException {
        System.out.println("Checking updates...");
        Scanner readFile = new Scanner(new File(localGlobalVersion));
        globalVersion = readFile.nextLine();
        readFile.close();
        if (new File(localGlobalVersion).exists()) {
            try {
                Files.delete(Paths.get(localGlobalVersion, new String[0]));
            }
            catch (IOException e) {
                System.out.println("Local global version does not exist...");
            }
        }
        if (globalVersion.equals(Main.version)) {
            main = false;
            AppWindow.updates.setText("No updates!");
            AppWindow.updates.setForeground(Color.green);
            System.out.println("No updates found!");
        } else {
            main = true;
            AppWindow.updates.setText("Update available: " + globalVersion);
            AppWindow.updates.setForeground(Color.yellow);
            System.out.println("Update available!");
        }
    }
}

