/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Path
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static JFrame pathWindow = new JFrame("Set Alternate Path");

    public Path() throws IOException {
        this.setLayout(null);
        JLabel path = new JLabel("Settings:");
        JLabel note = new JLabel("<html>NOTE: This is NOT a path to your GAME installation, it is a path to your SETTINGS location. Where your graphics settings, control mapping, and saves are stored.<br>It needs to contain Fallout4.ini and Fallout4Prefs.ini.</html>", 0);
        JButton saveExit = new JButton("Save and close");
        final JTextField pathText = new JTextField(Main.path);
        saveExit.setBounds(200, 80, 150, 40);
        note.setBounds(10, 11, 500, 80);
        path.setBounds(10, -5, 200, 40);
        pathText.setBounds(75, 7, 450, 18);
        this.add(path);
        this.add(pathText);
        this.add(saveExit);
        this.add(note);
        saveExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pathWindow.dispose();
                try {
                    Path.writePath(pathText.getText());
                }
                catch (IOException e1) {
                    System.out.println("Failed to write path to file!");
                    e1.printStackTrace();
                }
                Main.findGame();
            }
        });
    }

    public static void getPath() throws IOException {
        if (new File("Path.cfg").exists()) {
            Scanner readFile = new Scanner(new File("Path.cfg"));
            Main.path = readFile.nextLine();
            readFile.close();
            System.out.println("Path read from file: " + Main.path);
        } else {
            Path.writePath(String.valueOf(Main.userDir) + "/Documents/My Games/Fallout4/");
        }
    }

    public static void writePath(String path) throws IOException {
        path = path.replace("\\", "/");
        System.out.println("Saving new path to file: " + path);
        if (!path.contains("/")) {
            System.out.println("Potential formatting error found with path, ignoring...");
        }
        PrintWriter writeFile = new PrintWriter(new File("Path.cfg"));
        writeFile.println(path);
        writeFile.close();
        Main.path = path;
    }

    public static void resetPath() {
        if (new File("Path.cfg").exists()) {
            try {
                Files.delete(new File("Path.cfg").toPath());
            }
            catch (IOException e) {
                System.out.println("Unable to delete Path.cfg!");
                e.printStackTrace();
            }
        } else {
            System.out.println("Path.cfg doesn't exist!");
        }
        System.exit(0);
    }
}

