/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Scanner;

public class Install {
    static String[] settings = new String[4];
    static boolean done = false;
    static boolean fail = false;
    static String user_ini = String.valueOf(Main.path) + "/Fallout4.ini";
    static String userprefs_ini = String.valueOf(Main.path) + "/Fallout4Prefs.ini";
    static String userbck_ini = String.valueOf(Main.path) + "/Fallout4_ULG_backup.ini";
    static String userprefsbck_ini = String.valueOf(Main.path) + "/Fallout4Prefs_ULG_backup.ini";

    public static void doInstall() throws Exception {
        AppWindow.status.setText("Reading settings...");
        AppWindow.status.setForeground(Color.WHITE);
        try {
            Scanner file = new Scanner(new File(userprefs_ini));
            String line = "";
            while (file.hasNextLine()) {
                line = file.nextLine();
                if (line.contains("bFull Screen")) {
                    Install.settings[0] = line;
                }
                if (line.contains("iSize H")) {
                    Install.settings[1] = line;
                }
                if (line.contains("iSize W")) {
                    Install.settings[2] = line;
                }
                if (!line.contains("sD3DDevice")) continue;
                Install.settings[3] = line;
            }
            file.close();
            System.out.println("Read settings: " + Arrays.toString(settings));
        }
        catch (FileNotFoundException e) {
            System.out.println("Fallout4Prefs.ini not found!");
            AppWindow.status.setText("Installation failed!");
            AppWindow.status.setForeground(Color.red);
            AppWindow.installB.setEnabled(true);
            AppWindow.installB.setText("Finish");
            done = true;
            e.printStackTrace();
        }
        int i = 0;
        while (i < settings.length) {
            if (settings[i] == null) {
                fail = true;
            }
            ++i;
        }
        if (!fail) {
            System.out.println("Installing templates...");
            if (!new File(userbck_ini).exists() && !new File(userprefsbck_ini).exists() && new File(user_ini).exists() && new File(userprefs_ini).exists()) {
                Files.move(Paths.get(user_ini, new String[0]), Paths.get(userbck_ini, new String[0]), new CopyOption[0]);
                Files.move(Paths.get(userprefs_ini, new String[0]), Paths.get(userprefsbck_ini, new String[0]), new CopyOption[0]);
            }
            Install.exportResource("/data/UltraLow.ini", false);
            Install.exportResource("/data/UltraLowPrefs.ini", true);
            Install.install();
        } else {
            System.out.println("Failed to read settings from file!");
            AppWindow.status.setText("Installation failed!");
            AppWindow.status.setForeground(Color.red);
            AppWindow.installB.setEnabled(true);
            AppWindow.installB.setText("Finish");
            done = true;
        }
    }

    public static void install() throws IOException, InterruptedException {
        System.out.println("Writing user settings to templates...");
        Path path = Paths.get(userprefs_ini, new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(path), charset);
        content = content.replaceAll("fullscreen_unit_here", settings[0]);
        content = content.replaceAll("height_pixel_unit_here", settings[1]);
        content = content.replaceAll("width_pixel_unit_here", settings[2]);
        content = content.replaceAll("graphics_processor_unit_here", settings[3]);
        content = content.replaceAll("cpu_thread_unit_here", Integer.toString(Runtime.getRuntime().availableProcessors()));
        Files.write(path, content.getBytes(charset), new OpenOption[0]);
        System.out.println("Settings written, installation complete!");
        AppWindow.status.setText("Installation complete!");
        AppWindow.status.setForeground(Color.green);
        AppWindow.installB.setEnabled(true);
        AppWindow.installB.setText("Finish");
        done = true;
        new File(user_ini).setWritable(false);
        new File(userprefs_ini).setWritable(false);
    }

    public static void exportResource(String resourceName, boolean prefs) throws Exception {
        System.out.println(user_ini);
        new File(user_ini).setWritable(true);
        new File(userprefs_ini).setWritable(true);
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            try {
                int readBytes;
                stream = Main.class.getResourceAsStream(resourceName);
                if (stream == null) {
                    System.out.println("Cannot get resource \"" + resourceName + "\" from jar file.");
                }
                byte[] buffer = new byte[4096];
                String jarFolder = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getPath().replace('\\', '/');
                resStreamOut = prefs ? new FileOutputStream(userprefs_ini) : new FileOutputStream(user_ini);
                while ((readBytes = stream.read(buffer)) > 0) {
                    resStreamOut.write(buffer, 0, readBytes);
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                AppWindow.status.setText("Installation failed!");
                AppWindow.status.setForeground(Color.red);
                AppWindow.installB.setEnabled(true);
                AppWindow.installB.setText("Finish");
                done = true;
                stream.close();
                resStreamOut.close();
            }
        }
        finally {
            stream.close();
            resStreamOut.close();
        }
    }

    public static void uninstall() throws IOException {
        System.out.println("Uninstalling...");
        new File(userbck_ini).setWritable(true);
        new File(userprefsbck_ini).setWritable(true);
        new File(user_ini).setWritable(true);
        new File(userprefs_ini).setWritable(true);
        Files.move(Paths.get(userbck_ini, new String[0]), Paths.get(user_ini, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        Files.move(Paths.get(userprefsbck_ini, new String[0]), Paths.get(userprefs_ini, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        System.out.println("Uninstall complete!");
        AppWindow.status.setText("Backup restored!");
        AppWindow.status.setForeground(Color.green);
        AppWindow.installB.setEnabled(true);
        AppWindow.installB.setText("Finish");
        done = true;
    }
}

